/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.ftp.preferences;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.ide.core.io.preferences.PermissionDirection;
import com.aptana.ide.core.io.preferences.PreferenceUtils;
import com.aptana.ui.ftp.FTPUIPlugin;
import com.aptana.ui.ftp.preferences.Messages;
import com.aptana.ui.ftp.preferences.UpdatePermissionsComposite;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;

public class FTPPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private UpdatePermissionsComposite uploadPermComposite;
    private UpdatePermissionsComposite downloadPermComposite;
    private Text fKeepAliveText;

    public void init(IWorkbench workbench) {
        this.setDescription(Messages.FTPPreferencePage_Notes);
    }

    public boolean performOk() {
        PreferenceUtils.setUpdatePermissions((boolean)this.uploadPermComposite.getUpdatePermissions(), (PermissionDirection)PermissionDirection.UPLOAD);
        PreferenceUtils.setSpecificPermissions((boolean)this.uploadPermComposite.getSpecificPermissions(), (PermissionDirection)PermissionDirection.UPLOAD);
        PreferenceUtils.setFilePermissions((long)this.uploadPermComposite.getFilePermissions(), (PermissionDirection)PermissionDirection.UPLOAD);
        PreferenceUtils.setFolderPermissions((long)this.uploadPermComposite.getFolderPermissions(), (PermissionDirection)PermissionDirection.UPLOAD);
        PreferenceUtils.setUpdatePermissions((boolean)this.downloadPermComposite.getUpdatePermissions(), (PermissionDirection)PermissionDirection.DOWNLOAD);
        PreferenceUtils.setSpecificPermissions((boolean)this.downloadPermComposite.getSpecificPermissions(), (PermissionDirection)PermissionDirection.DOWNLOAD);
        PreferenceUtils.setFilePermissions((long)this.downloadPermComposite.getFilePermissions(), (PermissionDirection)PermissionDirection.DOWNLOAD);
        PreferenceUtils.setFolderPermissions((long)this.downloadPermComposite.getFolderPermissions(), (PermissionDirection)PermissionDirection.DOWNLOAD);
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.aptana.filesystem.ftp");
        prefs.putInt("KeepAliveTime", Integer.parseInt(this.fKeepAliveText.getText()));
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)FTPUIPlugin.getDefault(), (Throwable)e);
        }
        return super.performOk();
    }

    protected Control createContents(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        Group group = new Group(main, 0);
        group.setText(Messages.FTPPreferencePage_LBL_Uploads);
        group.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.uploadPermComposite = new UpdatePermissionsComposite((Composite)group, PermissionDirection.UPLOAD);
        this.uploadPermComposite.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).create());
        group = new Group(main, 0);
        group.setText(Messages.FTPPreferencePage_LBL_Downloads);
        group.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.downloadPermComposite = new UpdatePermissionsComposite((Composite)group, PermissionDirection.DOWNLOAD);
        this.downloadPermComposite.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).create());
        Composite keepAlive = new Composite(main, 0);
        keepAlive.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        keepAlive.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Label label = new Label(keepAlive, 0);
        label.setText(Messages.FTPPreferencePage_LBL_KeepAlive);
        this.fKeepAliveText = new Text(keepAlive, 2048);
        int initialTime = Platform.getPreferencesService().getInt("com.aptana.filesystem.ftp", "KeepAliveTime", 7, null);
        this.fKeepAliveText.setText(String.valueOf(initialTime));
        this.fKeepAliveText.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
        this.fKeepAliveText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FTPPreferencePage.this.validate();
            }
        });
        return main;
    }

    protected void performDefaults() {
        this.uploadPermComposite.restoreDefaults();
        this.downloadPermComposite.restoreDefaults();
        this.fKeepAliveText.setText(String.valueOf(7));
        super.performDefaults();
    }

    private void validate() {
        String error = null;
        String keepAliveMins = this.fKeepAliveText.getText();
        if (StringUtil.isEmpty((String)keepAliveMins)) {
            error = Messages.FTPPreferencePage_ERR_Invalid_KeepAlive_Time;
        } else {
            try {
                int mins = Integer.parseInt(keepAliveMins);
                if (mins <= 0) {
                    throw new NumberFormatException("negative");
                }
            }
            catch (NumberFormatException e) {
                error = Messages.FTPPreferencePage_ERR_Invalid_KeepAlive_Time;
            }
        }
        this.setErrorMessage(error);
        this.setValid(error == null);
    }
}

